import os
from PIL import Image

def get_smallest_image_size(folder_path):
    smallest_size = float('inf')

    for filename in os.listdir(folder_path):
        if filename.endswith(('.jpg', '.jpeg', '.png')):
            image_path = os.path.join(folder_path, filename)
            try:
                image = Image.open(image_path)
                width, height = image.size
                image.close()

                image_size = min(width, height)
                if image_size < smallest_size:
                    smallest_size = image_size
            except IOError:
                print(f"Error al abrir la imagen: {image_path}")

    if smallest_size == float('inf'):
        print("No se encontraron imágenes en la carpeta.")
    else:
        print(f"El tamaño de imagen más pequeño encontrado es: {smallest_size} píxeles.")

# Ruta de la carpeta actual
folder_path = os.getcwd()

# Obtener el tamaño de la imagen más pequeña
get_smallest_image_size(folder_path)
